
/************************************************************************
 *																								*
 *		D51 8051/52 Disassembler - Copyright (C) 1995-1996 by					*
 *		Jeffery L. Post																	*
 *		22726 Benner Ave.																	*
 *		Torrance, CA  90505																*
 *																								*
 *		D51P2.C - Disassembly Passes 2 & 3											*
 *																								*
 *		Version 2.4 - 08/19/96															*
 *																								*
 *	This program is free software; you can redistribute it and/or modify	*
 *	it under the terms of the GNU General Public License as published by	*
 *	the Free Software Foundation; either version 2 of the License, or		*
 *	(at your option) any later version.												*
 *																								*
 *	This program is distributed in the hope that it will be useful,		*
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of			*
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the			*
 *	GNU General Public License for more details.									*
 *																								*
 *	You should have received a copy of the GNU General Public License		*
 *	along with this program; if not, write to the Free Software				*
 *	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.				*
 *																								*
 ************************************************************************/

#include	<stdio.h>
#include	<stdlib.h>
#include	<ctype.h>
#include	<string.h>
#include	"d51.h"
#include	"d51.tbl"				/* get global tables */

#ifdef	MSDOS
#include	<dos.h>
#endif

#ifdef	LINUX
#include	<time.h>
#endif

/*
	This ugly looking thing is used in pass 3 to determine whether
	a miscellaneous equate statement should be generated. The equate
	statement will be written to the disassembly file if the location
	is referenced by some instruction and either it is a split reference
	or the location is uninitialized and the location does not have an
	entry in the label table. If the above requirements are met except
	that the location has an entry in the label table, then an equate
	statement will be generated as a label equate.
*/

#define	MISC_EQU_TAG	\
((pflag & PF_REF) && \
!(pflag & PF_CLREF) && \
((pflag & PF_SPLIT) | (pflag & PF_NOINIT)))

/*********************
 *							*
 *		Prototypes		*
 *							*
 *********************/

void	pass2(void);
void	pass3(void);
void	doopcode(char *mnem);
void	dodir(FILE *fp, word dir);
void	dobit(FILE *fp, word bit);
void	chk_ref(word i);
void	splitcheck(word i);
void	puthex(word j);
int	ascii(int i);
int	is_ascii(byte data);

extern char	*find_entry(word val, word count, SYM_PTR *table);
extern void	dump_ascii(word adrs);
extern void	dump_bytes(word adrs);

/***************************
 *									*
 *		Global variables		*
 *									*
 ***************************/

int	newline;								/* just output newline flag	*/

#ifdef	MSDOS
struct date	date_data;					/* disassembly date				*/
struct time	time_data;					/* disassembly time				*/
#endif

#ifdef	LINUX
struct tm	*date_time;					/* disassembly time				*/
#endif

extern word	himark;						/* highest data adrs				*/
extern char	src[32], dst[32];		   /* file name buffers				*/
extern FILE	*fp;							/* dos file struct				*/
extern int	hexflag;						/* append hex flag				*/
extern int	kcnt;							/* output char counter			*/
extern word	offset;						/* program offset					*/
extern byte	*pmem;						/* program data pointer			*/
extern byte	*pflg;						/* pointer to program flags	*/
extern char	defbstr[8];					/* string for defined bytes	*/
extern char	defwstr[8];					/* string for defined words	*/
extern char	string[ASCLIMIT];			/* ascii data for defb			*/
extern word	asc_cnt;						/* count for string data		*/
extern byte	byte_data[BYTELIMIT];	/* binary data for defb			*/
extern word	byte_cnt;					/* count for binary data		*/
extern byte	dump;							/* dump just done flag			*/
extern byte	ascii_flag;					/* use ascii string flag		*/
extern byte	dirregs[32];				/* access flags for dir reg	*/
extern word	symbol_count;				/* number of symbols				*/
extern word	label_count;				/* number of labels				*/

extern SYM_PTR	*sym_val_index;		/* symbol table pointer array	*/
extern SYM_PTR	*lab_val_index;		/* label table pointer array	*/

/*********************
 *							*
 *			Code			*
 *							*
 *********************/

/************************************************************************

	Pass two of disassembly. Rescan data array and generate output file.
	Generate label if location flagged as referenced by some other opcode.
	If un-initialized data is encountered, ignore it but set skip flag so
	that an ORG statement can be generated when the next initialized data
	is found.

************************************************************************/

void pass2(void)
{
	char	c, *cptr;
	int	skip;
	word	i, l, q, temp;
	byte	j, k, pflag;

#ifdef	LINUX
	time_t	tp;
#endif

	k = 0;
	j = 0xff;
	skip = 1;
	dump = 0;
	byte_cnt = 0;
	asc_cnt = 0;
	newline = 0;

	printf("\nPass 2 0000");

	if ((fp = fopen(dst, "w")) == NULL)			/* open output source file */
	{
		printf("\n* Can't open file %s *\n", dst);
		exit(FILE_ERROR);
	}
	fprintf(fp, ";\n;  8051 Disassembly of %s", src);	/* output header */

#ifdef	MSDOS
	getdate(&date_data);
	gettime(&time_data);
	fprintf(fp, "\n;  %d/%d/%d %d:%02d", date_data.da_mon, date_data.da_day,
		date_data.da_year, time_data.ti_hour, time_data.ti_min);
#endif

#ifdef	LINUX
	time(&tp);									/* get current time */
	date_time = localtime(&tp);			/* convert to hr/min/day etc */
	fprintf(fp, "\n;  %d/%d/%d %d:%02d", date_time->tm_mon + 1,
		date_time->tm_mday, date_time->tm_year,
		date_time->tm_hour, date_time->tm_min);
#endif

	if (ascii_flag)					/* if user specified A on command line... */
	{
		fprintf(fp, "\n;\nascii\tmacro\tx");		/* generate macro for text */
		fprintf(fp, "\n\t%s\t'#x#'", defbstr);
		fprintf(fp, "\n\tendm");
	}

/*  Generate output file */

	for (i=offset; i<himark; )
	{
		l = i & 0xff;
		pflag = pflg[i];
		if (pflag == PF_INIT)					/* ignore un-initialized data */
		{
			if (byte_cnt)				/* if binary or ascii data in buffers... */
				dump_bytes(i);			/* output them now */
			if (asc_cnt)
				dump_ascii(i);
			if (dump)					/* if we had to flush buffers...	*/
			{								/* do a newline, since we will	*/
				dump = 0;				/* be doing an org (or end)		*/
				fprintf(fp, "\n;");
				newline++;
			}
			i++;										/* next program location */
			skip = 1;								/* flag skip for ORG statement */
			j = -1;
		}
		else if (pflag & (PF_ADRS | PF_WORD | PF_BYTE | PF_ASCII))
		{												/* if not executable code */
			if (!(j & 0x80) && !skip)
			{
				j = -1;
				fprintf(fp, "\n;");
				newline++;
			}
			switch (pflag & ~PF_REF)			/* ignore reference bit */
			{
				case PF_ASCII:						/* if ascii text... */
					if (byte_cnt)					/* dump any pending binary */
						dump_bytes(i);
					if (skip)						/* insert ORG statement */
					{
						if (!newline)
							fprintf(fp, "\n;");
						fprintf(fp, "\n\torg\t");
						puthex(i);
						fprintf(fp, "\n;");
						newline++;
						skip = 0;					/* reset skip flag */
					}
					if (is_ascii(pmem[i]))		/* if it really is ascii... */
					{
						string[asc_cnt] = pmem[i];
						asc_cnt++;
						if (asc_cnt >= ASCLIMIT)
							dump_ascii(i);
					}
					else								/* else treat it as binary data */
					{
						pflg[i] |= PF_BYTE;
						if (asc_cnt)				/* dump any accumulated ascii */
							dump_ascii(i);
						byte_data[byte_cnt] = pmem[i];	/* add data to buffer */
						byte_cnt++;
					}
					break;

				case PF_WORD:					/* if word data... */
					if (byte_cnt)			/* dump any binary or ascii in buffers */
						dump_bytes(i);
					if (asc_cnt)
						dump_ascii(i);
					if (skip)					/* insert ORG statement */
					{
						if (!newline)
							fprintf(fp, "\n;");
						fprintf(fp, "\n\torg\t");
						puthex(i);
						fprintf(fp, "\n;");
						newline++;
						skip = 0;				/* reset skip flag */
					}
					chk_ref(i);							/* add label if referenced */
					q = ((word) pmem[i]) << 8;		/* get word value */
					temp = pmem[i + 1] & 0xff;
					q |= temp;
					fprintf(fp, "%s\t", defwstr);
					cptr = find_entry(q, symbol_count, sym_val_index);	/* see if symbol exists */
					if (cptr == NULL)						/* if not, do hex value */
						puthex(q);
					else
						fprintf(fp, "%s", cptr);		/* else output symbol */
					if (hexflag)							/* add comment field */
						fprintf(fp, "\t\t; %04x   %02x %02x      %c%c",
							i, pmem[i], pmem[i+1], ascii(pmem[i]), ascii(pmem[i+1]));
					i++;
					if (pflg[i + 2] != PF_ADRS && pflg[i + 2] != PF_WORD)
					{
						fprintf(fp, "\n;");
						newline++;
					}
					break;

				case PF_ADRS:					/* if address data... */
					if (byte_cnt)				/* output any pending binary or */
						dump_bytes(i);			/* ascii data from buffers */
					if (asc_cnt)
						dump_ascii(i);
					if (skip)					/* insert ORG statement */
					{
						if (!newline)
							fprintf(fp, "\n;");
						fprintf(fp, "\n\torg\t");
						puthex(i);
						fprintf(fp, "\n;");
						newline++;
						skip = 0;				/* reset skip flag */
					}
					chk_ref(i);					/* add label if referenced */
					q = ((word) pmem[i]) << 8;	/* get address value */
					temp = pmem[i + 1] & 0xff;
					q |= temp;
					fprintf(fp, "%s\t", defwstr);
					cptr = find_entry(q, label_count, lab_val_index);	/* see if label exists */
					if (cptr == NULL)						/* if not, output hex */
					{
						cptr = find_entry(q, symbol_count, sym_val_index);
						if (cptr == NULL)
							fprintf(fp, "X%04x", q);
						else
							fprintf(fp, "%s", cptr);
					}
					else
						fprintf(fp, "%s", cptr);		/* else output label text */
					if (hexflag)							/* do comment field */
						fprintf(fp, "\t\t; %04x   %02x %02x      %c%c",
							i, pmem[i], pmem[i+1],
							ascii(pmem[i]), ascii(pmem[i+1]));
					i++;
					if (pflg[i + 2] != PF_ADRS)
					{
						fprintf(fp, "\n;");
						newline++;
					}
					break;

				default:							/* default = binary data... */
					if (asc_cnt)				/* output any pending ascii data */
						dump_ascii(i);
					if (skip)					/* insert ORG statement */
					{
						if (!newline)
							fprintf(fp, "\n;");
						fprintf(fp, "\n\torg\t");
						puthex(i);
						fprintf(fp, "\n;");
						newline++;
						skip = 0;				/* reset skip flag */
					}
					byte_data[byte_cnt] = pmem[i];	/* add data to buffer */
					byte_cnt++;
					if (byte_cnt >= BYTELIMIT)			/* if end of buffer...	*/
						dump_bytes(i);						/* dump accumulated data */
			}
			i++;									/* next program location */
			if (pflg[i] != PF_INIT && pflg[i] & PF_ASCII)
			{										/* if next byte is flagged as	*/
				if (!is_ascii(pmem[i]))		/* ascii, but is not...			*/
					pflg[i] |= PF_BYTE;		/* then flag it as binary		*/
			}
		}

/*	If previous data was an unconditional transfer, AND current
	location is not referenced by some other opcode, AND current
	byte is 0 or 0FFH, then treat this byte as un-initialized data.
*/

		else if ((j & 0x80) && (!(pflag & PF_REF)) &&
				((pmem[i] == 0) || (pmem[i] == NO_DATA)))
		{
			if (byte_cnt)				/* since we're going to skip some */
				dump_bytes(i);			/* data, output any pending ascii */
			if (asc_cnt)				/* or binary data remaining in buffers */
				dump_ascii(i);
			if (dump)					/* if ascii or binary output was done, */
			{								/* stick in a newline */
				fprintf(fp, "\n;");
				dump = 0;
				newline++;
			}
			pflg[i] = PF_INIT;		/* flag as uninitialized data */
			i++;
			skip = 1;
			byte_cnt = 0;
		}

/* If previous opcode was 0 or 0ffH, AND current location is not
	referenced but is initialized, AND current opcode is 0 or 0ffH,
	un-initialize it.
*/

		else if ((k == 0 || k == 0xff) &&
			(!(pflag & PF_REF)) && (pmem[i] == 0 || pmem[i] == 0xff) &&
			(!(pflag & PF_CLREF)) && !(pflag & PF_NOINIT))
		{
			pflg[i] = '\xff';
			i++;
			skip = 1;
			fprintf(fp, "\t; data truncated");
			j = -1;
		}

		else								/**** IT'S EXECUTABLE CODE! ****/
		{
			pflg[i] &= ~PF_NOINIT;	/* clear for label search in pass 3 */
			if (byte_cnt)				/* if any ascii or binary data remains */
				dump_bytes(i);			/* in the buffers, output them now */
			if (asc_cnt)
				dump_ascii(i);
			if (dump)
			{
				fprintf(fp, "\n;");
				dump = 0;
				newline++;
			}
			byte_cnt = 0;
			if (skip)						/* insert ORG statement */
			{
				if (!newline)
					fprintf(fp, "\n;");
				fprintf(fp, "\n\torg\t");
				puthex(i);
				fprintf(fp, "\n;");
				newline++;
				skip = 0;					/* reset skip flag */
			}

			k = pmem[i];						/* get opcode */
			if (k == 0xa5 && !newline)		/* if invalid opcode */
			{
				fprintf(fp, "\n;");
				newline++;
			}
			chk_ref(i);							/* add label if referenced */
			kcnt = 8;
			j = opttbl[k];						/* get options */
			doopcode(mnemtbl[k].mcode);	/* output mnemonic */

	/* Generate operands */

			switch (j & OPT_MASK)
			{
					/* single byte - no options */

				case OPT_NONE:
					break;

					/* 2 byte immediate data */

				case OPT_IMM2:
					q = (word) pmem[i + 1] & 0xff;
					cptr = find_entry(q, symbol_count, sym_val_index);
					if (cptr == NULL)
						puthex(pmem[i + 1]);
					else
						kcnt += fprintf(fp, "%s", cptr);
					splitcheck(i + 1);
					break;

					/* 3 byte immediate data */

				case OPT_LREF:
					q = ((pmem[i+1] & 0xff) << 8) | (pmem[i+2] & 0xff);
					cptr = find_entry(q, label_count, lab_val_index);
					if (cptr == NULL)
					{
						cptr = find_entry(q, symbol_count, sym_val_index);
						if (cptr == NULL)
							kcnt += fprintf(fp, "X%04x", q);
					}
					if (cptr != NULL)
						kcnt += fprintf(fp, "%s", cptr);
					splitcheck(i+1);
					splitcheck(i+2);
					break;

					/* 2 byte direct addressing */

				case OPT_DIR2:
					dodir(fp, pmem[i+1]);
					if ((k & 0xf) == 2 || k == 0xf5)
						kcnt += fprintf(fp, ",a");
					else if ((k & 0xf0) == 0x80)
					{
						kcnt += fprintf(fp, ",");
						if (k < 0x88)
							kcnt +=  fprintf(fp, "@r%d", k&1);
						else
							kcnt += fprintf(fp, "r%d", k & 7);
					}
					splitcheck(i+1);
					break;

					/* mov dir,dir */

				case OPT_DIR3:
					dodir(fp, pmem[i+2]);
					kcnt += fprintf(fp, ",");
					dodir(fp, pmem[i+1]);
					splitcheck(i+1);
					splitcheck(i+2);
					break;

					/* 3 byte direct and immediate addressing */

				case OPT_DMM3:
					dodir(fp, pmem[i+1]);
					kcnt += fprintf(fp, ",#");
					q = (word) pmem[i + 2] & 0xff;
					cptr = find_entry(q, symbol_count, sym_val_index);
					if (cptr == NULL)
						puthex(pmem[i + 2]);
					else
						kcnt += fprintf(fp, "%s", cptr);
					splitcheck(i+1);
					splitcheck(i+2);
					break;

					/* 2 byte bit addressing */

				case OPT_BIT2:
					dobit(fp, pmem[i+1]);
					if (k == 0x92)
						kcnt += fprintf(fp, ",c");
					splitcheck(i+1);
					break;

					/* 2 byte relative addressing */

				case OPT_REL2:
					q = pmem[i+1] & 0xff;
					q = (q > 0x7f) ? q | 0xff00 : q;
					q = i + 2 + q;
					cptr = find_entry(q, label_count, lab_val_index);
					if (cptr == NULL)
						kcnt += fprintf(fp, "X%04x", q);
					else
						kcnt += fprintf(fp, "%s", cptr);
					splitcheck(i+1);
					break;

					/* 3 byte immediate and relative addressing */

				case OPT_IR3:
					q = (word) pmem[i + 1] & 0xff;
					cptr = find_entry(q, symbol_count, sym_val_index);
					if (cptr == NULL)
						puthex(pmem[i + 1]);
					else
						kcnt += fprintf(fp, "%s", cptr);
					q = pmem[i+2] & 0xff;
					q = (q > 0x7f) ? q | 0xff00 : q;
					q = i + 3 + q;
					cptr = find_entry(q, label_count, lab_val_index);
					if (cptr == NULL)
						kcnt += fprintf(fp, ",X%04x", q);
					else
						kcnt += fprintf(fp, ",%s", cptr);
					splitcheck(i+1);
					splitcheck(i+2);
					break;

					/* 3 byte direct and relative addressing */

				case OPT_DR3:
					dodir(fp, pmem[i+1]);
					q = pmem[i+2] & 0xff;
					q = (q > 0x7f) ? q | 0xff00 : q;
					q = i + 3 + q;
					cptr = find_entry(q, label_count, lab_val_index);
					if (cptr == NULL)
						kcnt += fprintf(fp, ",X%04x", q);
					else
						kcnt += fprintf(fp, ",%s", cptr);
					splitcheck(i+1);
					splitcheck(i+2);
					break;

					/* 3 byte bit and relative addressing */

				case OPT_RELB:
					dobit(fp, pmem[i+1]);
					q = pmem[i+2] & 0xff;
					q = (q > 0x7f) ? q | 0xff00 : q;
					q = i + 3 + q;
					cptr = find_entry(q, label_count, lab_val_index);
					if (cptr == NULL)
						kcnt += fprintf(fp, ",X%04x", q);
					else
						kcnt += fprintf(fp, ",%s", cptr);
					splitcheck(i+1);
					splitcheck(i+2);
					break;

					/* 2 byte 11 bit adrs (ajmp & acall) */

				case OPT_112:
					q = ((k & 0xe0) << 3) | ((i + 2) & 0xf800);
					q = q | (pmem[i+1] & 0xff);
					cptr = find_entry(q, label_count, lab_val_index);
					if (cptr == NULL)
						kcnt += fprintf(fp, "X%04x", q);
					else
						kcnt += fprintf(fp, "%s", cptr);
					splitcheck(i+1);
					break;
			}

			if (k == 0xa5)				/* if invalid opcode */
				puthex(k);				/* put hex defb in file */

			if (hexflag)				/* do comment field */
			{
				while (kcnt < TSTOP)
				{
					fprintf(fp, "\t");
					kcnt = (kcnt + 8) & 0x78;
				}
				fprintf(fp,"; %04x   %02x", i, pmem[i] & 0xff);
				switch (opttbl[k] & OPT_SIZE)			/* additional data bytes */
				{
					case 0:
						fprintf(fp, "      ");
						break;
					case 1:
						fprintf(fp, " %02x   ", pmem[i+1] & 0xff);
						break;
					case 2:
						fprintf(fp, " %02x %02x",
							pmem[i+1] & 0xff, pmem[i+2] & 0xff);
				}
				fprintf(fp, "   %c", ascii(pmem[i]));
				switch (opttbl[k] & OPT_SIZE)			/* additional ascii */
				{
					case 1:
						fprintf(fp, "%c", ascii(pmem[i+1]));
						break;
					case 2:
						fprintf(fp, "%c%c",
							ascii(pmem[i+1]), ascii(pmem[i+2]));
				}
			}

			newline = 0;
			i = i + (opttbl[k] & OPT_SIZE) + 1;	/* update location counter */

			if (j & OPT_XFER || k == 0xa5)	/* if unconditional transfer or */
			{											/* invalid code, add a newline */
				fprintf(fp, "\n;");
				newline++;
			}
		}
		if ((i & 0xff) < l)
			printf("\rPass 2 %04x", i & 0xff00);
	}
	if (byte_cnt)					/* if any remaining ascii or binary, */
		dump_bytes(i);				/* output it now */
	if (asc_cnt)
		dump_ascii(i);
	printf("\rPass 2 - Source generation complete");

/* add equates for register names */

	j = 0;
	for (i=0; i<32; i++)
	{
		if (dirregs[i])
		{
			if (!j)
			{
				if (!newline || dump)
					fprintf(fp, "\n;");
				fprintf(fp, "\n;\tregister equates\n;");
				newline = 0;
			}
			fprintf(fp, "\n%s\tequ\t", &rbname[i].dent[0]);
			puthex(i);
			j = 1;
		}
	}
}													/*  End of Pass 2 */

/*********************************************************************
 *																							*
 *						Pass three of disassembly									*
 *	Search for references to un-initialized data or split references	*
 *	and, if found, generate EQU statements for them.						*
 *																							*
 *********************************************************************/

void pass3(void)
{
	word	i, j, k, index, val;
	struct sym	*ptr;
	char	*cptr;
	byte	pflag;

	printf("\nPass 3 0000");

	/* search label table for labels referenced but not generated */

	j = 1;
	for (index=0; index<label_count; index++)
	{
		ptr = lab_val_index[index];
		if (ptr->used)
		{
			val = ptr->val;
			val = (word) pflg[val];
			val &= (PF_NOINIT | PF_CLREF | PF_SPLIT | PF_REF);
			if (val == (PF_REF | PF_SPLIT) || val == (PF_REF | PF_NOINIT))
			{
				if (j)								/* do header if first one */
				{
					j = 0;
					if (!newline || dump)
						fprintf(fp, "\n;");
					fprintf(fp, "\n;\tlabel equates\n;\n;"
						"  these are labels in the control file that reference\n;"
						"  the middle of a multibyte instruction or reference\n;"
						"  an address outside the initialized space\n;");
				}
				fprintf(fp, "\n%s\tequ\t", ptr->name);
				puthex(ptr->val);
				newline = 0;
			}
		}
	}

	/* now do equates for symbol table */

	j = 1;
	for (index=0; index<symbol_count; index++)
	{
		ptr = sym_val_index[index];
		if (ptr->used)								/* do header if first one */
		{
			if (j)
			{
				j = 0;
				if (!newline || dump)
					fprintf(fp, "\n;");
				fprintf(fp, "\n;\tsymbol equates\n;\n;"
								"  these are symbols from the control\n;"
								"  file that are referenced in the code\n;");
			}
			fprintf(fp, "\n%s\tequ\t", ptr->name);
			puthex(ptr->val);
			newline = 0;
		}
	}

	j = 1;
	for (i=0; ; )
	{
		k = i & 0xfff;
		pflag = pflg[i];

		/* if location is referenced and un-initialized or is a split ref */

		if (MISC_EQU_TAG)
		{
			cptr = find_entry(i, label_count, lab_val_index);
			if (cptr == NULL)					/* if not in label list */
			{
				if (j)							/* do header if first one */
				{
					j = 0;
					if (!newline || dump)
						fprintf(fp, "\n;");
					fprintf(fp, "\n;\tmiscellaneous equates\n;\n;"
									"  these are addresses referenced in the code but\n;"
									"  which are in the middle of a multibyte instruction\n;"
									"  or are addresses outside the initialized space\n;");
					newline = 0;
				}
				fprintf(fp, "\nX%04x\tequ\t", i);		/* do EQU statement */
				puthex(i);
			}
		}
		i++;
		if (!(i & 0xffff))	/* the '& 0xffff' is required since GCC */
			break;				/* thinks an unsigned short int is 32 bits */
		if ((i & 0xfff) < k)						/* go figure */
			printf("\rPass 3 %04x", i);
	}

	printf("\rPass 3 - Equate generation complete");
	if (!newline || dump)
		fprintf(fp, "\n");
	fprintf(fp, ";\n\tend\n;\n\n");
	fflush(fp);
	fclose(fp);
}												/*  End of Pass 3   */

/***************************************
 *													*
 *		Output opcode for current code	*
 *													*
 ***************************************/

void doopcode(char *mnem)
{
	char	c;

	c = *mnem++;
	while (c)						/* output text from opcode table */
	{
		if (c == ' ')				/* convert spaces to tabs */
		{
			putc('\t', fp);
			kcnt = (kcnt + 8) & 0x78;
		}
		else
		{
			putc(c, fp);
			kcnt++;
		}
		c = *mnem++;
	}
}

/*********************************************
 *															*
 *		Output operand for direct addressing	*
 *															*
 *********************************************/

void dodir(FILE *fp, word dir)
{
	dir &= 0xff;
	if (dir < 0x20)
	{
		kcnt += fprintf(fp, rbname[dir].dent);
		dirregs[dir] = 1;
	}
	else if (dir < 0x80)
		kcnt += fprintf(fp, "%02xh", dir);
	else
		kcnt += fprintf(fp, "%s", sfr[dir & 0x7f].dent);
}

/***************************
 *									*
 *		Output sfr bit name	*
 *									*
 ***************************/

void dobit(FILE *fp, word bit)
{
	int	i;

	bit &= 0xff;
	if (bit < 0x80)
	{
		i = (bit >> 3) + 0x20;
		kcnt += fprintf(fp, "%02xh.%d", i, bit & 7);
	}
	else
		kcnt += fprintf(fp, "%s", sfrbits[bit & 0x7f].dent);
}

/*********************************************************************
 *																							*
 *	add label to output line if current location marked as referenced	*
 *																							*
 *********************************************************************/

void chk_ref(word i)
{
	int	cnt;
	char	*cptr;

	if ((pflg[i] & (PF_REF | PF_CLREF)) == PF_REF)
	{
		cptr = find_entry(i, label_count, lab_val_index);			/* see if label exists */
		if (cptr == NULL)
			cnt = fprintf(fp, "\nX%04x:", i);	/* if not, output hex value */
		else
			cnt = fprintf(fp, "\n%s:", cptr);	/* else output label text */
		if (cnt > 8)
			fprintf(fp, "\n\t");
		else
			fprintf(fp, "\t");
	}
	else
		fprintf(fp, "\n\t");
}

/***************************************************
 *																	*
 *		Check for reference to address in middle of	*
 *		code and flag split reference if true			*
 *																	*
 ***************************************************/

void splitcheck(word i)
{
	if (!(pflg[i] & PF_CLREF))		/* ignore if not referenced */
		pflg[i] |= PF_SPLIT;			/* else flag split ref */
}

/************************************************************************
 *																								*
 *		Check if data is printable ascii other than the string delimiter	*
 *																								*
 ************************************************************************/

int is_ascii(byte data)
{
	if (data < ' ' || data > 0x7e || data == '\'')
		return(0);
	return(1);
}

/************************************
 *												*
 *		Output hexadecimal operand		*
 *												*
 ************************************/

void puthex(word j)
{
	if (j < 10)
		kcnt += fprintf(fp, "%x", j);
	else if (j < 16)
		kcnt += fprintf(fp, "0%xh", j);
	else if (j < 0xa0)
		kcnt += fprintf(fp, "%xh", j);
	else if (j < 0x100)
		kcnt += fprintf(fp, "0%xh", j);
	else if (j < 0xa00)
		kcnt += fprintf(fp, "%xh", j);
	else if (j < 0x1000)
		kcnt += fprintf(fp, "0%xh", j);
	else if (j < 0xa000)
		kcnt += fprintf(fp, "%xh", j);
	else
		kcnt += fprintf(fp, "0%xh", j);
}

/******************************************
 *														*
 *		Convert code to printable ascii		*
 *														*
 ******************************************/

int ascii(int i)
{
	i = i & 0x7f;
	if (i == 0x7f)
		return ('.');
	else if (i < 0x20)
		return ('.');
	else
		return (i);
}

/* end of d51p2.c */

